/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.FactionOption;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.util.Util;

public class SubGuiNpcFactionOptions
extends SubGuiInterface
implements IScrollData,
ICustomScrollListener,
ITextfieldListener {
    private final Map<String, Integer> data = new HashMap<String, Integer>();
    private final FactionOptions options;
    private GuiCustomScroll scroll;

    public SubGuiNpcFactionOptions(FactionOptions factionOptions) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.options = factionOptions;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 1: {
                this.change(button.getValue() == 1, this.getTextField(1) == null ? 0 : this.getTextField(1).getInteger());
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    private void change(boolean isTake, int value) {
        if (!this.scroll.hasSelected() || !this.data.containsKey(this.scroll.getSelected())) {
            return;
        }
        FactionOption fo = null;
        int id = -1;
        if (this.scroll.getSelected() != null && this.data.containsKey(this.scroll.getSelected())) {
            id = this.data.get(this.scroll.getSelected());
            fo = this.options.get(id);
        }
        if (fo == null) {
            if (value == 0) {
                return;
            }
            fo = new FactionOption(id, value, isTake);
            this.options.fps.add(fo);
        } else if (value == 0) {
            if (this.options.remove(id)) {
                fo = null;
            }
        } else {
            fo.factionPoints = value;
            fo.decreaseFactionPoints = isTake;
        }
        if (fo != null) {
            fo.check();
        }
        this.setData(null, new HashMap<String, Integer>(this.data));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(120, 196);
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 14;
        this.addScroll(this.scroll);
        this.addLabel(new GuiNpcLabel(1, new TextComponentTranslation("faction.options", new Object[0]).func_150254_d() + ":", this.guiLeft + 5, this.guiTop + 4));
        FactionOption fo = null;
        if (this.scroll.getSelected() != null && this.data.get(this.scroll.getSelected()) != null) {
            fo = this.options.get(this.data.get(this.scroll.getSelected()));
        }
        GuiNpcLabel label = new GuiNpcLabel(2, new TextComponentTranslation("gui.settings", new Object[0]).func_150254_d() + ":", this.guiLeft + 130, this.guiTop + 4);
        label.enabled = this.scroll.getSelect() >= 0;
        this.addLabel(label);
        GuiNpcTextField textField = new GuiNpcTextField(1, this, this.field_146289_q, this.guiLeft + 130, this.guiTop + 16, 110, 20, fo != null ? "" + fo.factionPoints : "0");
        textField.setMinMaxDefault(-100000L, 100000L, fo != null ? (long)fo.factionPoints : 0L);
        textField.func_146184_c(this.scroll.getSelect() >= 0);
        textField.setHoverText("faction.hover.option.points", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(1, this.guiLeft + 130, this.guiTop + 38, 90, 20, new String[]{"gui.add", "gui.decrease"}, fo != null ? (fo.decreaseFactionPoints ? 1 : 0) : 0);
        button.setIsVisible(this.scroll.getSelect() >= 0);
        button.setHoverText("faction.hover.option.decrease", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, this.guiLeft + 130, this.guiTop + this.ySize - 26, 90, 20, "gui.back");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void initPacket() {
        Client.sendData(EnumPacketServer.FactionsGet, new Object[0]);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    @Override
    public void setData(Vector<String> list, HashMap<String, Integer> dataMap) {
        this.data.clear();
        String name = Util.instance.deleteColor(this.scroll.getSelected());
        if (name != null && name.contains("ID:") && name.indexOf(" - ") >= name.indexOf("ID:")) {
            name = name.substring(name.indexOf(" - ") + 3);
        }
        ArrayList<String> newList = new ArrayList<String>();
        HashMap<String, String> hoverMap = new HashMap<String, String>();
        HashMap<String, Integer> newData = new HashMap<String, Integer>();
        for (String key : dataMap.keySet()) {
            int id = dataMap.get(key);
            String newName = Util.instance.deleteColor(key);
            if (newName.contains("ID:" + id + " - ")) {
                newName = newName.substring(newName.indexOf(" - ") + 3);
            }
            newName = new TextComponentTranslation(newName, new Object[0]).func_150254_d();
            String str = "\u00a77ID:" + id + " - " + newName;
            if (this.options.hasFaction(id)) {
                FactionOption fo = this.options.get(id);
                str = "\u00a77ID:" + id + " - " + '\u00a7' + (fo.decreaseFactionPoints ? "c" : "2") + newName;
            }
            newList.add(str);
            hoverMap.put(str, newName);
            newData.put(str, id);
            if (name == null || !name.equals(Util.instance.deleteColor(newName))) continue;
            name = str;
        }
        Collections.sort(newList);
        this.data.putAll(newData);
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        int i = 0;
        for (String key : newList) {
            hts.put(i, Collections.singletonList(hoverMap.get(key)));
            ++i;
        }
        this.scroll.setListNotSorted(newList);
        this.scroll.setHoverTexts(hts);
        if (name != null) {
            this.scroll.setSelected(name);
        }
        this.func_73866_w_();
    }

    @Override
    public void setSelected(String selected) {
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        this.change(this.getButton(1) != null && this.getButton(1).getValue() == 1, textField.getInteger());
    }
}

